package com.bca2021.sqlitedemo;

import androidx.appcompat.app.AppCompatActivity;

import android.database.sqlite.SQLiteConstraintException;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TableLayout;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {


    EditText e_id, e_name, e_age;
    Button b_add, b_edit, b_del, b_view;
    TableLayout tbl;
    SQLite sqLite;


    public void references() {
        e_id = findViewById(R.id.m_e_id);
        e_name = findViewById(R.id.m_e_name);
        e_age = findViewById(R.id.m_e_age);

        b_add = findViewById(R.id.m_b_add);
        b_edit = findViewById(R.id.m_b_edit);
        b_del = findViewById(R.id.m_b_del);
        b_view = findViewById(R.id.m_b_view);

        tbl = findViewById(R.id.tbl);


    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        references();
        sqLite = new SQLite(this);

        b_add.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String id = e_id.getText().toString();
                String name = e_name.getText().toString();
                String age = e_age.getText().toString();
                if (id.equals("") && name.equals("") && age.equals("")) {
                    Toast.makeText(MainActivity.this, "Data is Empty", Toast.LENGTH_SHORT).show();
                } else {
                    Boolean data = sqLite.insertData(id, name, age);
                    if (data == false) {
                        Toast.makeText(MainActivity.this, "Something is wrong in Database.", Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(MainActivity.this, "Record Inserted Successfully.", Toast.LENGTH_SHORT).show();
                    }
                }

            }
        });
        b_edit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String id = e_id.getText().toString();
                String name = e_name.getText().toString();
                String age = e_age.getText().toString();
                if (id.equals("") && name.equals("") && age.equals("")) {
                    Toast.makeText(MainActivity.this, "Data is Empty", Toast.LENGTH_SHORT).show();
                } else {
                    Boolean data = sqLite.updateData(id, name, age);
                    if (data == false) {
                        Toast.makeText(MainActivity.this, "Something is wrong in Database.", Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(MainActivity.this, "Record Updated Successfully.", Toast.LENGTH_SHORT).show();
                    }
                }

            }
        });


    }
}