package com.mscit2020.searchviewdemo;

import androidx.appcompat.app.AppCompatActivity;

import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.SearchView;
import android.widget.Toast;

import java.util.ArrayList;

public class MainActivity extends AppCompatActivity {

    SearchView searchView;
    ListView listView;
    ArrayList<String> arrayList;
    ArrayAdapter<String> arrayAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        searchView = findViewById(R.id.searchbar);
        listView = findViewById(R.id.list);

        arrayList = new ArrayList<>();
        arrayList.add("Mango");
        arrayList.add("Melon");
        arrayList.add("Strawberry");
        arrayList.add("Gauva");
        arrayList.add("Apple");
        arrayList.add("Grapes");
        arrayList.add("Lichhi");
        arrayList.add("WaterMelon");

        arrayAdapter = new ArrayAdapter<>(getApplicationContext(), android.R.layout.simple_list_item_1, arrayList);
        listView.setAdapter(arrayAdapter);
        listView.setBackgroundColor(Color.rgb(100, 200, 50));
        listView.setVisibility(View.INVISIBLE);

        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            @Override
            public boolean onQueryTextSubmit(String query) {
                if (arrayList.contains(query)) {
                    arrayAdapter.getFilter().filter(query);
                    listView.setVisibility(View.VISIBLE);
                } else
                    Toast.makeText(MainActivity.this, "No Data Found", Toast.LENGTH_SHORT).show();
                return false;
            }

            @Override
            public boolean onQueryTextChange(String query) {
                if (arrayList.contains(query)) {
                    listView.setVisibility(View.VISIBLE);
                    arrayAdapter.getFilter().filter(query);
                } else
                    listView.setVisibility(View.INVISIBLE);
                return false;
            }
        });

    }
}