package com.mscit2020.tabhost;

import androidx.appcompat.app.AppCompatActivity;

import android.app.TabActivity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.TabHost;
import android.widget.Toast;

public class MainActivity extends TabActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);


        TabHost tabHost = findViewById(android.R.id.tabhost);

        TabHost.TabSpec tabSpec;
        Intent intent;

        tabSpec = tabHost.newTabSpec("Home");
        tabSpec.setIndicator("Home");
        intent = new Intent(MainActivity.this,Home.class);
        tabSpec.setContent(intent);
        tabHost.addTab(tabSpec);


        tabSpec = tabHost.newTabSpec("About");
        tabSpec.setIndicator("ABout");
        intent = new Intent(MainActivity.this,About.class);
        tabSpec.setContent(intent);
        tabHost.addTab(tabSpec);

        tabHost.setCurrentTab(0);

        tabHost.setOnTabChangedListener(new TabHost.OnTabChangeListener() {
            @Override
            public void onTabChanged(String s) {
                Toast.makeText(MainActivity.this, "Changed", Toast.LENGTH_SHORT).show();
            }
        });

    }
}