package com.mscit2020.expandablelistviewdemo;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by Hardik Chavda on 3/22/2021.
 * Freelancer
 * hardikkchavda@gmail.com
 */

class ExpandableAdapter extends BaseExpandableListAdapter {

    ArrayList<String> listCategory;
    Map<String, ArrayList<String>> mapChild;
    Context mContext;

    public ExpandableAdapter(ArrayList<String> listCategory, Map<String, ArrayList<String>> mapChild, Context context) {
        this.listCategory = listCategory;
        this.mapChild = mapChild;
        this.mContext = context;
    }

    @Override
    public int getGroupCount() {
        return listCategory.size();
    }

    @Override
    public int getChildrenCount(int group) {
        return mapChild.get(listCategory.get(group)).size();
    }

    @Override
    public Object getGroup(int group) {
        return listCategory.get(group);
    }

    @Override
    public Object getChild(int group, int child) {
        return mapChild.get(listCategory.get(group)).get(child);
    }

    @Override
    public long getGroupId(int i) {
        return 0;
    }

    @Override
    public long getChildId(int i, int i1) {
        return 0;
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public View getGroupView(int group, boolean isExpanded, View view, ViewGroup parent) {
        String cat = (String) getGroup(group);
        view = LayoutInflater.from(mContext).inflate(R.layout.parent, null);
        TextView tv = view.findViewById(R.id.t_parent);
        tv.setText(cat);
        return view;
    }

    @Override
    public View getChildView(int group, int child, boolean isExpanded, View view, ViewGroup parent) {
        String cat = (String) getChild(group, child);
        view = LayoutInflater.from(mContext).inflate(R.layout.child, null);
        TextView tv = view.findViewById(R.id.t_child);
        tv.setText(cat);
        return view;
    }

    @Override
    public boolean isChildSelectable(int i, int i1) {
        return true;
    }
}
