package com.mscit2020.expandablelistviewdemo;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MainActivity extends AppCompatActivity {


    ExpandableListView expandableListView;
    ExpandableAdapter expandableAdapter;
    ArrayList<String> listCategory;
    Map<String,ArrayList<String>> mapChild;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        expandableListView = findViewById(R.id.expandableView);
        listCategory = new ArrayList<>();
        mapChild = new HashMap<>();
        dataTODisplay();

    }

    private void dataTODisplay() {

        ArrayList<String> commerce = new ArrayList<>();
        ArrayList<String> computer = new ArrayList<>();
        ArrayList<String> management = new ArrayList<>();

        listCategory.add("Commerce");
        listCategory.add("Computer Science");
        listCategory.add("Management");

        commerce.add("B.Com");
        commerce.add("M.Com");

        computer.add("BCA");
        computer.add("BSCIT");
        computer.add("MSCIT");
        computer.add("PGDCA");

        management.add("BBA");
        management.add("MBA");

        mapChild.put(listCategory.get(0),commerce);
        mapChild.put(listCategory.get(1),computer);
        mapChild.put(listCategory.get(2),management);

        expandableAdapter = new ExpandableAdapter(listCategory,mapChild,this);
        expandableListView.setAdapter(expandableAdapter);

    }
}