package com.mscit2020.wallpapermanager;

import androidx.appcompat.app.AppCompatActivity;

import android.app.WallpaperManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;

import java.io.File;
import java.io.IOException;

public class MainActivity extends AppCompatActivity {

    Button btn;
    ImageView img;
    File file;
    String[] FilePathString;
    File[] listFile;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        img = findViewById(R.id.image);
        btn = findViewById(R.id.btn);

        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            Toast.makeText(this, "No Storage Found", Toast.LENGTH_SHORT).show();
        } else {
            file = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES) + File.separator + "Images");
        }
        if (file.isDirectory()){
            //To use listFiles after android 10+ you have to use legacystorageoption in your manifest file.
            listFile  = file.listFiles();
            FilePathString = new String[listFile.length];
            for (int i=0;i<listFile.length;i++)
            {
                FilePathString[i] = listFile[i].getAbsolutePath();
            }
            Bitmap bmp = BitmapFactory.decodeFile(FilePathString[1].toString());
            img.setImageBitmap(bmp);
        }

        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                WallpaperManager manager = WallpaperManager.getInstance(getApplicationContext());
                Bitmap bmp = BitmapFactory.decodeFile(FilePathString[1].toString());
                try {
                    manager.setBitmap(bmp);
                } catch (IOException e) {
                    Toast.makeText(MainActivity.this, e.getMessage(), Toast.LENGTH_SHORT).show();
                }
            }
        });

    }
}