package com.mscit2020.cameraapidemo;

import androidx.appcompat.app.AppCompatActivity;

import android.hardware.Camera;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.Toast;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

public class MainActivity extends AppCompatActivity {

    Button btn_capture;
    FrameLayout frameLayout;
    Camera camera;
    ShowCamera showCamera;
    Camera.PictureCallback mPictureCallback = new Camera.PictureCallback() {
        @Override
        public void onPictureTaken(byte[] data, Camera camera) {
            String PATHSAVE = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM)
                    + UUID.randomUUID().toString() + "_img.jpg";
            if (PATHSAVE == null)
                return;
            else {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(PATHSAVE);
                    fos.write(data);
                } catch (FileNotFoundException e) {
                    Toast.makeText(MainActivity.this, e.getMessage(), Toast.LENGTH_SHORT).show();
                } catch (IOException e) {
                    Toast.makeText(MainActivity.this, e.getMessage(), Toast.LENGTH_SHORT).show();
                } finally {
                    try {
                        fos.close();
                    } catch (IOException e) {
                        Toast.makeText(MainActivity.this, e.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        btn_capture = findViewById(R.id.btn_capture);
        frameLayout = findViewById(R.id.frameLayout);
        camera = Camera.open();
        showCamera = new ShowCamera(camera, this);
        frameLayout.addView(showCamera);

        btn_capture.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (camera != null)
                    camera.takePicture(null, null, mPictureCallback);
            }
        });

    }
}