package com.mscit2020.blutoothexample;

import androidx.appcompat.app.AppCompatActivity;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.icu.text.UnicodeSetSpanner;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.Set;

public class MainActivity extends AppCompatActivity {

    Button b_on, b_off, b_list, b_visible;
    ListView listView;
    BluetoothAdapter bluetoothAdapter;
    Set<BluetoothDevice> pairedDevices;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        b_on = findViewById(R.id.b_on);
        b_off = findViewById(R.id.b_off);
        b_list = findViewById(R.id.b_list);
        b_visible = findViewById(R.id.b_visible);
        listView = findViewById(R.id.deviceList);

        bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

        b_on.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!bluetoothAdapter.isEnabled()) {
                    Intent turnOn = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                    startActivity(turnOn);
                    Toast.makeText(MainActivity.this, "Turned On", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(MainActivity.this, "Already On", Toast.LENGTH_SHORT).show();
                }
            }
        });

        b_off.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                bluetoothAdapter.disable();
                Toast.makeText(MainActivity.this, "Turned Off", Toast.LENGTH_SHORT).show();
            }
        });

        b_visible.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent visibility = new Intent(BluetoothAdapter.ACTION_REQUEST_DISCOVERABLE);
                startActivity(visibility);
            }
        });

        b_list.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                pairedDevices = bluetoothAdapter.getBondedDevices();
                ArrayList list = new ArrayList();
                for (BluetoothDevice bt : pairedDevices) {
                    list.add(bt.getName());
                }
                Toast.makeText(MainActivity.this, "Showing Paired Devices..", Toast.LENGTH_SHORT).show();
                ArrayAdapter adapter = new ArrayAdapter(getApplicationContext(), android.R.layout.simple_list_item_1, list);
                listView.setAdapter(adapter);
            }
        });


    }
}