package com.mscit2020.wifidemo;

import androidx.appcompat.app.AppCompatActivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import java.util.List;

public class MainActivity extends AppCompatActivity {

    Button b_enable, b_refresh, b_disable, b_wifi;
    TextView txt;
    WifiManager manager;
    WifiReciever wifiReciever;
    StringBuilder sb;
    List<ScanResult> wifiDevices;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        b_enable = findViewById(R.id.b_enable);
        b_disable = findViewById(R.id.b_disable);
        b_refresh = findViewById(R.id.b_refresh);
        b_wifi = findViewById(R.id.b_enable10);
        txt = findViewById(R.id.txt);


        manager = (WifiManager) getApplicationContext().getSystemService(WIFI_SERVICE);


        b_enable.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (manager.isWifiEnabled() == false) {
                    manager.setWifiEnabled(true);
                    Toast.makeText(MainActivity.this, "Wifi Turned On..", Toast.LENGTH_SHORT).show();
                }
                wifiReciever = new WifiReciever();
                registerReceiver(wifiReciever, new IntentFilter(WifiManager.SCAN_RESULTS_AVAILABLE_ACTION));
                manager.startScan();
                txt.setText("Start Scanning...");
            }
        });

        b_disable.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                manager.setWifiEnabled(false);
                Toast.makeText(MainActivity.this, "Wifi Turned off.", Toast.LENGTH_SHORT).show();
                txt.setText("");
            }
        });

        b_refresh.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (manager.isWifiEnabled() == true) {
                    manager.startScan();
                    txt.setText("Scanning again...");
                } else {
                    Toast.makeText(MainActivity.this, "Wifi is disabled..", Toast.LENGTH_SHORT).show();
                }
            }
        });

        //For Android 10 and above
        b_wifi.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent panelIntent = new Intent(Settings.Panel.ACTION_INTERNET_CONNECTIVITY);
                startActivity(panelIntent);
            }
        });

    }


    private class WifiReciever extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            sb = new StringBuilder();
            wifiDevices = manager.getScanResults();
            sb.append(" Number of Wifi Devices :" + wifiDevices.size() + "\n");
            for (int i = 0; i < wifiDevices.size(); i++) {
                sb.append(new Integer(i + 1).toString() + ", ");
                sb.append(wifiDevices.get(i).toString());
                sb.append("\n");
            }
            txt.setText(sb);
        }
    }
}