package com.mscit2020.pullparserex;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MainActivity extends AppCompatActivity {

    TextView txt;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        txt = findViewById(R.id.t_data);
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            InputStream is = getAssets().open("data.xml");
            //parser.setFeature(XmlPullParser.FEATURE_PROCESS_NAMESPACES,false);
            parser.setInput(is, "utf-8");
            processParser(parser);
        } catch (XmlPullParserException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG).show();
        } catch (IOException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG).show();
        }

    }

    private void processParser(XmlPullParser parser) {
        ArrayList<Items> items = new ArrayList<>();
        try {
            int eventType = parser.getEventType();
            Items currentItem = null;
            while (eventType != XmlPullParser.END_DOCUMENT) {
                String eltName = null;
                switch (eventType) {
                    case XmlPullParser.START_TAG:
                        eltName = parser.getName();
                        if (eltName.equals("item")) {
                            currentItem = new Items();
                            items.add(currentItem);
                        } else if (currentItem != null) {
                            if (eltName.equals("name"))
                                currentItem.name = parser.nextText();
                            else if (eltName.equals("qty"))
                                currentItem.qty = parser.nextText();

                        }
                        break;
                }
                eventType = parser.next();
            }
            printItems(items);
        } catch (XmlPullParserException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG).show();
        } catch (IOException e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG).show();
        }
    }

    private void printItems(ArrayList<Items> items) {
        StringBuilder builder = new StringBuilder();
        for (Items item : items) {
            builder.append(item.name).append("\n")
                    .append(item.qty).append("\n");
        }
        txt.setText(builder);
    }
}

class Items {
    public String name, qty;
}