package com.mscit2020.xmlsaxparserex;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

public class MainActivity extends AppCompatActivity {

    TextView txt;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        txt = findViewById(R.id.t_dta);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        AlertDialog builder = new AlertDialog.Builder(this).create();
        builder.setTitle("SAXParser Example");
        try {
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler() {
                boolean name = false;
                boolean qty = false;


                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    super.startElement(uri, localName, qName, attributes);
                    if (qName.equals("name"))
                        name = true;
                    if (qName.equals("qty"))
                        qty = true;
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    super.characters(ch, start, length);
                    if (name) {
                        txt.setText(txt.getText() + "\nName " + new String(ch, start, length));
                        name = false;
                    }
                    if (qty) {
                        txt.setText(txt.getText() + "\nQuantity " + new String(ch, start, length));
                        qty = false;
                    }
                }
            };


            InputStream is = getAssets().open("data");
            parser.parse(is, handler);


        } catch (ParserConfigurationException e) {
            builder.setMessage(e.getMessage() + " Parser");
            builder.show();
        } catch (SAXException e) {
            builder.setMessage(e.getMessage() + " SAX");
            builder.show();
        } catch (IOException e) {
            builder.setMessage(e.getMessage() + " IO");
            builder.show();
        }


    }
}