package com.mscit2020.dompareserex;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class MainActivity extends AppCompatActivity {

    TextView txt;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        txt = findViewById(R.id.t_data);
        AlertDialog alertDialog = new AlertDialog.Builder(this).create();

        try {
            InputStream is = getAssets().open("data.xml");

            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);

            Element ele = doc.getDocumentElement();
            ele.normalize();
            NodeList nList = ele.getElementsByTagName("item");


            for (int i = 0; i < nList.getLength(); i++) {
                Node node = nList.item(i);
                if (node.getNodeType() == Node.ELEMENT_NODE) {
                    Element ele2 = (Element) node;
                    txt.setText(txt.getText() + "\nName: " + getValue("name", ele2) + "\n");
                    txt.setText(txt.getText() + "\nQuantity: " + getValue("qty", ele2) + "\n");
                }
            }

        } catch (IOException e) {
            alertDialog.setMessage(e.getMessage()+" IO ");
            alertDialog.show();
        } catch (ParserConfigurationException e) {
            alertDialog.setMessage(e.getMessage()+" Parser ");
            alertDialog.show();
        } catch (SAXException e) {
            alertDialog.setMessage(e.getMessage() +" DOMExc ");
            alertDialog.show();
        }
    }

    private String getValue(String name, Element ele2) {
        NodeList nodeList = ele2.getElementsByTagName(name).item(0).getChildNodes();
        Node node = nodeList.item(0);
        return node.getNodeValue();

    }
}