package com.mscit2020.propertyanimation;

import androidx.appcompat.app.AppCompatActivity;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

public class MainActivity extends AppCompatActivity {

    Button b_alpha, b_rotate, b_scale, b_trans, b_set;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        b_alpha = findViewById(R.id.b_aplha);
        b_rotate = findViewById(R.id.b_rotate);
        b_scale = findViewById(R.id.b_scale);
        b_trans = findViewById(R.id.b_trans);
        b_set = findViewById(R.id.b_set);


        //Value Animator
        ValueAnimator va = ValueAnimator.ofFloat(100f, 0f);
        va.setRepeatCount(1);
        va.setRepeatMode(ValueAnimator.REVERSE);
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                b_alpha.setAlpha((Float) valueAnimator.getAnimatedValue());
            }
        });

        ValueAnimator vr = ValueAnimator.ofFloat(360);
        vr.setRepeatCount(1);
        vr.setRepeatMode(ValueAnimator.REVERSE);
        vr.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                b_rotate.setRotation((Float) valueAnimator.getAnimatedValue());
            }
        });

        //ObjectAnimator
        ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat(b_alpha, View.ALPHA, 0);
        alphaAnimation.setRepeatCount(1);
        alphaAnimation.setRepeatMode(ValueAnimator.REVERSE);

        ObjectAnimator rotateAnimation = ObjectAnimator.ofFloat(b_rotate, View.ROTATION, 360);
        rotateAnimation.setRepeatCount(1);
        rotateAnimation.setRepeatMode(ValueAnimator.REVERSE);

        PropertyValuesHolder pX = PropertyValuesHolder.ofFloat(View.SCALE_X, 2);
        PropertyValuesHolder pY = PropertyValuesHolder.ofFloat(View.SCALE_Y, 2);
        ObjectAnimator scaleAnimation = ObjectAnimator.ofPropertyValuesHolder(b_scale, pX, pY);
        scaleAnimation.setRepeatCount(1);
        scaleAnimation.setRepeatMode(ValueAnimator.REVERSE);

        ObjectAnimator transAnimation = ObjectAnimator.ofFloat(b_trans, View.TRANSLATION_X, 400);
        transAnimation.setRepeatCount(1);
        transAnimation.setRepeatMode(ValueAnimator.REVERSE);

        b_alpha.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //Value Animator
//                va.setDuration(3000);
//                va.start();

                alphaAnimation.setDuration(3000);
                alphaAnimation.start();
            }
        });

        b_rotate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //Value Animator
//                vr.setDuration(3000);
//                vr.start();

                rotateAnimation.setDuration(3000);
                rotateAnimation.start();
            }
        });

        b_scale.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                scaleAnimation.setDuration(3000);
                scaleAnimation.start();
            }
        });

        b_trans.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                transAnimation.setDuration(3000);
                transAnimation.start();
            }
        });

        b_set.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                AnimatorSet animatorSet = new AnimatorSet();
                animatorSet.play(alphaAnimation).after(rotateAnimation).before(scaleAnimation);
                animatorSet.play(transAnimation).after(scaleAnimation);
                animatorSet.setDuration(3000);
                animatorSet.start();
            }
        });


    }
}