package com.mscit2020.paintcanvasdemo;

import androidx.appcompat.app.AppCompatActivity;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.media.Image;
import android.os.Bundle;
import android.os.Environment;
import android.widget.ImageView;
import android.widget.Toast;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class BitmapActivity extends AppCompatActivity {
    ImageView img;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_bitmap);
        img = findViewById(R.id.imageView);

        //Creating a bitmap.
        Bitmap pathBitmap = Bitmap.createBitmap(300, 300, Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(pathBitmap);

        //Creating a drawing
        Paint paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        paint.setColor(Color.BLUE);
        canvas.drawCircle(200, 200, 100, paint);
        //showing drawing
        img.setImageBitmap(pathBitmap);

        //saving the dawing as image in external storage.
        File filePath = new File(Environment.getExternalStorageDirectory().toString(), "Circle.jpg");
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            pathBitmap.compress(Bitmap.CompressFormat.JPEG, 80, fos);
        } catch (Exception e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG).show();
        }


    }
}