package com.mscit2020.paintcanvasdemo;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Bundle;
import android.view.View;

public class MainActivity extends AppCompatActivity {

    DemoView demoView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        demoView = new DemoView(this);
        setContentView(demoView);
    }


    private class DemoView extends View {
        public DemoView(Context context) {
            super(context);
        }

        @Override
        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);

            Paint paint = new Paint();

            paint.setStyle(Paint.Style.FILL);
            paint.setColor(Color.WHITE);
            canvas.drawPaint(paint);

            paint.setColor(Color.BLUE);
            //Draws the circle
            paint.setAntiAlias(true);
            canvas.drawCircle(100, 100, 100, paint);

            paint.setColor(Color.GREEN);
            paint.setAntiAlias(true);
            canvas.drawRect(400, 400, 200, 200, paint);


            paint.setColor(Color.BLACK);
            paint.setTextSize(100);
            paint.setAntiAlias(true);
            canvas.rotate(10);
            canvas.drawText("Hello", 100, 500, paint);


        }
    }
}